// wiostream -- initialize standard wide streams
#include <fstream>

 #if _IS_EMBEDDED

 #else /* _IS_EMBEDDED */
#include <iostream>
#include <new>
_STD_BEGIN

		// OBJECT DECLARATIONS
_CRTIMP2 int _Winit::_Init_cnt = -1;	// net constructors - destructors
_CRTIMP2 static wfilebuf wfin(_Noinit);	// uninitialized wcin buffer
_CRTIMP2 static wfilebuf wfout(_Noinit);	// uninitialized wcout buffer
_CRTIMP2 static wfilebuf wferr(_Noinit);	// uninitialized wcerr/wclog buffer
_CRTIMP2 wistream wcin(_Noinit);	// uninitialized wcin
_CRTIMP2 wostream wcout(_Noinit);	// uninitialized wcout
_CRTIMP2 wostream wcerr(_Noinit);	// uninitialized wcerr
_CRTIMP2 wostream wclog(_Noinit);	// uninitialized wclog

_CRTIMP2 _Winit::_Winit()
	{	// initialize standard wide streams first time
	bool doinit;
		{	// lock and test whether to initialize
		_Lockit lock(_LOCK_STREAM);
		if (0 <= _Init_cnt)
			++_Init_cnt, doinit = false;	// redundant initialization, skip
		else
			_Init_cnt = 1, doinit = true;	// first initialization, do it
		}

	if (doinit)
		{	// initialize standard wide streams
		new (&wfin) wfilebuf(stdin);
		new (&wfout) wfilebuf(stdout);
		new (&wferr) wfilebuf(stderr);
		new (&wcin) wistream(&wfin, true);
		new (&wcout) wostream(&wfout, true);
		wcin.tie(&wcout);
		new (&wcerr) wostream(&wferr, true);

 #if _HAS_STRICT_CONFORMANCE

 #else /* _HAS_STRICT_CONFORMANCE */
		wcerr.tie(&wcout);
 #endif /* _HAS_STRICT_CONFORMANCE */

		wcerr.setf(ios_base::unitbuf);
		new (&wclog) wostream(&wferr, true);
		wclog.tie(&wcout);
		}
	}

_CRTIMP2 _Winit::~_Winit()
	{	// flush standard wide streams on last destruction
	bool doflush;
		{	// lock and test whether to flush streams
		_Lockit lock(_LOCK_STREAM);
		if (--_Init_cnt == 0)
			doflush = true;	// last destruction, do it
		else
			doflush = false;	// not last destruction, skip
		}

	if (doflush)
		{	// flush standard wide streams, but don't destroy
		wcout.flush();
		wcerr.flush();
		wclog.flush();
		}
	}
_STD_END
 #endif /* _IS_EMBEDDED */

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
